<?php
// model class, talks with the database
class Teams extends Dbh{

	protected function getTeams(){
		$query ="SELECT * FROM teams";
		$stmt = $this->connect()->prepare($query);
		$stmt->execute();
		$result = $stmt->fetchAll(\PDO::FETCH_ASSOC);
		return $result;
	}
	protected function getIndividualTeam($team_id){
		$query ="SELECT * FROM teams WHERE team_id=?";
		$stmt = $this->connect()->prepare($query);
		$stmt->execute([$team_id]);
		$result = $stmt->fetchAll(\PDO::FETCH_ASSOC);
		return $result;

	}
	protected function getBudget($team_id,$month_year){
		$query= "SELECT * FROM budget WHERE team_id=? AND month_year=?";
		$stmt = $this->connect()->prepare($query);
		$stmt->execute([$team_id,$month_year]);
		$result = $stmt->fetchAll(\PDO::FETCH_ASSOC);
		return $result;

	}
	protected function getActual($team_id,$month_year){
		$query ="SELECT * FROM actual WHERE team_id=? AND month_year=?";
		$stmt = $this->connect()->prepare($query);
		$stmt->execute([$team_id,$month_year]);
		$result = $stmt->fetchAll(\PDO::FETCH_ASSOC);
		return $result;
	}

}