<?php
require'session.php';
ob_start();
 ?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <meta http-equiv="X-UA-Compatible" content="ie=edge" />
        <title>Invoice</title>
        <link
            href="https://fonts.googleapis.com/css2?family=Inter:wght@400;700&display=swap"
            rel="stylesheet"
        />
        <style>
            @media print {
                @page {
                    size: A4;
                }
            }
            ul {
                padding: 0;
                margin: 0 0 1rem 0;
                list-style: none;
            }
            body {
                font-family: "Inter", sans-serif;
                margin: 0;
            }
            table {
                width: 100%;
                border-collapse: collapse;
            }
            table,
            table th,
            table td {
                border: 3px solid silver;
            }
            table th,
            table td {
                text-align: left;
                padding: 6px 6px 6px 0px;
            }
            h1,
            h4,
            p {
                margin: 0;
            }

            .container {
                padding: 20px 0;
                width: 1000px;
                max-width: 90%;
                margin: 0 auto;
            }

            .inv-title {
                padding: 10px;
                border: 1px solid silver;
                text-align: center;
                margin-bottom: 30px;
            }

            .inv-logo {
                width: 150px;
                display: block;
                margin: 0 auto;
                margin-bottom: 40px;
            }

            /* header */
            .inv-header {
                display: flex;
                margin-bottom: 20px;
            }
            .inv-header > :nth-child(1) {
                flex: 2;
            }
            .inv-header > :nth-child(2) {
                flex: 1;
            }
            .inv-header h2 {
                font-size: 20px;
                margin: 0 0 0.3rem 0;
            }
            .inv-header ul li {
                font-size: 15px;
                padding: 3px 0;
            }

            /* body */
            .inv-body table th,
            .inv-body table td {
                text-align: left;
            }
            .inv-body {
                margin-bottom: 30px;
            }

            /* footer */
            .inv-footer {
                display: flex;
                flex-direction: row;
            }
            .inv-footer > :nth-child(1) {
                flex: 2;
            }
            .inv-footer > :nth-child(2) {
                flex: 1;
            }
        </style>
    </head>


    <body>
        <div class="container">
            <!--<img src="./safari.jpg" class="#inv-logo" />-->
            <p align="center"><img src="./defaultlogo.jpg" class="#inv-logo" width="1000px" /><p>
            <br>
            <br>
            <div class="inv-header">
                <div>
                    <h2>Patient Details</h2>
                    <table style="text-align:left; border:0px">
                        <tr>
                        <td style ="text-align:left;border:0px"><strong>Name :</strong> <?php echo "Tinashe"; ?> </td>
                        </tr>
                        <tr>
                        <td style ="text-align:left;border:0px"><strong>Surname :</strong> <?php echo "Badza"; ?></td>
                        </tr>
                        <tr>
                        <td style ="text-align:left;border:0px"><strong>Date of Birth :</strong> <?php //echo $dob; ?> </td>
                        </tr>
                    </table>
                    </div>
                <div>
                    <table>
                    <tr>
                            <th>Practice Number</th>
                            <td><?php echo $practice_number?> </td>
                        </tr>
                        <tr>
                            <th>Service Date</th>
                            <td><?php echo $servicedate ?></td>
                        </tr>
                        <tr>
                            <th>Invoice Number </th>
                            <td><?php 
                             // $invoicedate = date("dmy",strtotime($dateoftreatment));
                             echo $new_invoice_number;
                             ?>
                            </td>
                        </tr>   
                        <tr>
                            <th>File Number</th>
                            <td><?php echo $file_number; ?></td>
                        </tr>
                    </table>
                </div>  
            </div>
            <div class="inv-body">
                    <h3>Medical Aid Details</h3>
                    <table style="text-align:left; border:0px">
                        <tr>
                       <td style ="text-align:left;border:0px; width:25%"><strong>Medical Aid:</strong> <?php echo$medical_aid_name; ?> </td>
                        <td style ="text-align:left;border:0px"><strong>Medical Number :</strong> <?php echo $medical_aid_number; ?>
                        <td style ="text-align:left;border:0px"><strong>Scheme : </strong> <?php echo ucwords($scheme) ?></td>
                        <td style ="text-align:left;border:0px"><strong>Date Joined : </strong> <?php echo $datejoined ?></td>
                    
                        </tr>
                    </table>
                    <table style="text-align:left; border:0px">
                        <tr>
                        <td style ="text-align:left;border:0px; width: 75%"><strong>Principal Member :</strong> <?php echo $principal_member; ?></td>
                <td style ="text-align:left;border:0px"><strong>Relation to Member :<strong> <?php echo $relation_to_member; ?>
                    </td>
                        </tr>
                    </table>
            <h3> Referring Doctor's Details</h3>
                    <p><strong>Ref Doctor:</strong> <?php echo $ref_doctor ?>  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Practice Number : <?php echo $doc_practice_number ?></p>
                    <br>
                    <p><strong>Diagnosis:</strong> <?php echo $diagnosis ?>  &nbsp; <?php echo ";". $modified_diagnosis."" ?></p>
            </div>
            <br>
            <div class="inv-body">

                <table>
                    <thead>
                        <th>ICD10 Code</th>
                        <th>Tariff Code</th>
                        <th>Treatment Description</th>
                        <th>Fee</th>
                    </thead>
                    <tbody>
                <?php
                       // require"connect.php";
                        //$med ='bomaid';
      $query= "SELECT   p.dateoftreatment,p.icdcode,e.code,e.investigation,e.fee FROM treatment AS p INNER JOIN $medical_aid AS e ON p.treatment1= e.code OR p.treatment2 =e.code OR p.treatment3 = e.code  OR p.treatment4 = e.code OR p.treatment5=e.code OR p.treatment6 = e.code OR p.treatment7 = e.code OR p.treatment8= e.code OR p.treatment9 =e.code WHERE p.file_number =$file_number AND p.dateoftreatment='$dateoftreatment' ";
                        $total_normal_invoice = 0;
                        $total_modifiers =0;
                        $select_normal_treatment = mysqli_query($connection,$query);
                        
                        while($row = mysqli_fetch_assoc($select_normal_treatment)){
                            // the query is producing the information, loop until all the data is printed out.
                            echo"<tr>";
                           // echo'<td>'.$row['dateoftreatment'].'</td>';
                          //  $date = $row['dateoftreatment'];
                           // $dates = $date;
                          
                           // echo '<td>'.date('d-F-Y', strtotime($date)).'</td>';
                            echo'<td>'.$row['icdcode'].'</td>';
                            echo'<td>'.$row['code'].'</td>';
                            echo'<td>'.$row['investigation'].'</td>';
                           echo'<td>'.number_format($row['fee'],2).'</td>';
                            echo"</tr>";
                            //add the total to display on the invoce
                            $total_normal_invoice = $total_normal_invoice + (double)$row['fee'];
                          //  $total_normal_invoice = $total_normal_invoice + (double)$fee;

                                        }
    
           $modifier_query =" SELECT m.dateoftreatment, m.icdcode,m.modifier,b.code,b.investigation,b.fee FROM modified AS m INNER JOIN $medical_aid  AS b ON b.code=m.treatment WHERE file_number= $file_number and dateoftreatment='$dateoftreatment'";
                $select_modifier_treatment = mysqli_query($connection,$modifier_query);
                    //puting a while insite the foreach
                       while($rows = mysqli_fetch_assoc($select_modifier_treatment)){
                           echo"<tr>";
                        //date of treatment
                      //  $date = $rows['dateoftreatment'];
                      //  echo'<td>'.date('d-F-Y',strtotime($date)).'</td>';
                        echo'<td>'.$rows['icdcode'].'</td>';
                        echo'<td>'.$rows['code'].'/00'.$rows['modifier']. '</td>'; // treatment is the code here
                        echo'<td>'.$rows['investigation'].'</td>';
                        echo'<td>'.number_format($rows['fee'],2).'</td>';
                       // echo'<td>'.$rows['extra'].'</td>';
                        echo"</tr>";
                        //total  modified fees
                        $total_modifiers = $total_modifiers +(double)$rows['fee']; 
                        
                        }
                    //end of the while inside the foreach
                        //print the other table data here 
                    //converting the total_invoice into 2 decimal format 
                      //  $total_invoice = number_format($total_invoice,2);
                        //calcuting the 10% that the patient pays 
                     $total_invoice = $total_normal_invoice + $total_modifiers;
                       $patients_contribution = $total_invoice * 10/100 ; //10 percent 
                     if($medical_aid=='bomaid' || $medical_aid=='botsogo'||$medical_aid_contribution =='bpomasstandard'||$medical_aid=='mva'){
                        //override the patients_contribution to 0;
                        $patients_contribution =0;

                     }
                   //  $patients_contribution = $total_invoice * 10/100 ; //10 percent 
                        //converting the patients contribution to 2 decimal places
                       // $patients_contribution = number_format($patients_contribution,2);
                        //geting the medical aid contribution
                     $medicalaid_contribution = $total_invoice - $patients_contribution;
                        //converting the medical contribution to 2 decimal places
                       // $medicalaid_contribution = number_format($medicalaid_contribution,2);

                        ?>
                        
                    </tbody>
                </table>
            </div>
            <div class="inv-footer">
                <div>
            <!--    <table style ="text-align:left;border:0px">
                        <tr>
                            <br>
                        <td style ="text-align:left;border:0px"><p>I hereby certify that I have received the aboce services</p></td>
                        </tr>
                        <tr>
                            <td style ="text-align:left;border:0px">Patient's / Guardian Signature ............................................</td>
                        </tr>
                    </table>-->
                
                </div>
                <div>
                    <table>
                        <tr>
                            <th>Total</th>
                            <td style="font-size: 18px">P<?php echo number_format($total_invoice,2); ?></td>
                        </tr>
                        <tr>
                            <th>10% PT Contribution</th>
                            <td style="font-size: 18px">P<?php echo number_format($patients_contribution,2); ?></td>
                        </tr>
                        <tr>
                            <th>Medical Aid Contribution</th>
                            <td style="font-size: 18px"><strong>P<?php echo number_format($medicalaid_contribution,2); ?></strong></td>
                        </tr>
                    </table>
                </div>
                
            </div>
            <br>
            <!--<p>I hereby certify that i have rendered the above services to the above named patient. I confirm that the patient I treated is 
                the patient named on this form.</p>-->
                <br>
    <!--    <table style ="text-align:left;border:0px">
            <tr>
                <td style ="text-align:left;border:0px"><strong>Physiotherapist :</strong> <?php echo $physio_name." ".$physio_surname; ?></td>
                </tr>
                    <tr>
                <td style ="text-align:left;border:0px"><strong>Signature</strong> .....................................</td>
            </tr><tr>
                <td style ="text-align:left;border:0px"><strong>Date :</strong> <?php echo date('d-F-Y', strtotime($dateoftreatment))?></td>
            </tr>
        </table>-->


                <div class="inv-header">
                <div>
                    <table style="text-align:left; border:0px">
                        <tr>
                        <td style ="text-align:left;border:0px"><strong>Physiotherapist :</strong><?php echo $physio_name." ".$physio_surname; ?> </td>
                        </tr>
                        <tr>
                        <td style ="text-align:left;border:0px"><strong>Signature : .........................................</td>
                        </tr>
                        <tr>
                        <td style ="text-align:left;border:0px"><strong>Date :</strong> <?php echo date('d-F-Y', strtotime($dateoftreatment))?> </td>
                        </tr>
                    </table>
                    </div>
                <div>
                    <table style="text-align:left; border:0px">
                    <tr>
                            <td style="text-align:left; border:0px"><strong>Patient/Member's Signature</strong>............................................... </td>
                        </tr>
                        <tr>
                            <td style="text-align:left; border:0px"><strong>Date : </strong><?php echo $servicedate ?></td>
                        </tr>   
                    </table>
                </div>  
            </div>




        </div>


         <?php
                                //storing the invoice details for bath details 
               $patient_amount = number_format($patients_contribution,2);
               $scheme_amount = $medicalaid_contribution;
                    $query = "SELECT * FROM claims WHERE file_number = $file_number AND dateoftreatment ='$dateoftreatment'";
                    $claims_result = mysqli_query($connection,$query);
                   // $result = mysqli_query($conn, $sql);
                $rowcount=mysqli_num_rows($claims_result); 
                if($rowcount > 0){ 
                // echo "do nothing";
                    //update the scheme amount and patient amount
                    $query = "UPDATE claims SET patient_amount = '$patient_amount', scheme_amount='$scheme_amount' WHERE file_number=$file_number AND dateoftreatment='$dateoftreatment'";
                    $update_query = mysqli_query($connection,$query);
                                                    if(!$update_query){
                                                        die('Update Query Failed'.mysqli_error($connection));
                                                    }else{
                                                        ///dones
                                                    }
                  }
                  else
                  { 
                //insert the record here for claims  
           
               if($scheme_amount == 0){

                        //do nothing because we cant store a 0 value in claims
               }else{

                                    // nested if checking the scheme _amount 
        $query = "INSERT into claims(file_number,dateoftreatment,invoice_number,patient_names,medical_aid_number,principal_member,relation_to_member,patient_amount,scheme_amount,medical_aid_name)";
        $query.="VALUES($file_number,'$dateoftreatment',$new_invoice_number,'$patient_names','$medical_aid_number','$principal_member','$relation_to_member','$patient_amount','$scheme_amount','$medical_aid')";
        $create_claim_query = mysqli_query($connection,$query);
                            if(!$create_claim_query){
                                die('Query Failed'. mysqli_error($connection));
                            }else{
                               //header("Location:physio.php");
                                //header( "refresh:0;url=physio.php" );
                            }
                            // add it into the inner if statement
               }

   
                  }

                            ?>
    </body>
</html>
